


data_test <- cbind(Gold_dt[,1], amazon_full_scaled, boeing_full_scaled, cattle_full_scaled, cocoa_full_scaled, coffee_full_scaled,
                   crude_full_scaled, nyse_full_scaled, silver_full_scaled, sp500_full_scaled, sugar_full_scaled, wheat_full_scaled)


# Gold_dt$Gold_Open, Cattle_dt$Cattle_Open + Coffee_dt$Coffee_Open + Crude_dt$Crude_Open + 
# Silver_dt$Silver_Open + sp500_dt$sp500_Open + Sugar_dt$Sugar_Open

ggplot(data_test, aes(x = Gold_Date)) +
  # geom_point(aes(y = amazon_full_scaled, colour = "Amazon")) +
  # geom_point(aes(y = boeing_full_scaled, colour = "Boeing")) +
  scale_x_date(date_labels = "%Y-%m-%d") +
  theme(axis.text.x = element_text(angle = 30, hjust = 1)) +
  geom_point(aes(y = crude_full_scaled, colour  = "Crude")) +
  geom_point(aes(y = sugar_full_scaled, colour  = "Sugar")) +
  geom_point(aes(y = wheat_full_scaled, colour = "Wheat")) +
  geom_point(aes(y = silver_full_scaled, colour = "Silver")) +
  labs(x = "Date", y = "Crude, Sugar, Wheat, Coffee, and Silver (Scaled)", colour = "Variables") 
  geom_point(aes(y = coffee_full_scaled, colour = "Coffee")) 
  # geom_point(aes(y = nyse_full_scaled), colour = "NYSE")  

summary(lm(Cattle_dt$Cattle_Open ~ Cocoa_dt$Cocoa_Open))



# anova(lm(Cattle_dt$Cattle_Open ~ Cocoa_dt$Cocoa_Open))



