


amazon_full_scaled <- (Amazon_dt$Amazon_Open - mean(Amazon_dt$Amazon_Open)) / sd(Amazon_dt$Amazon_Open)

boeing_full_scaled <- (Boeing_dt$Boeing_Open - mean(Boeing_dt$Boeing_Open)) / sd(Boeing_dt$Boeing_Open)

cattle_full_scaled <- (Cattle_dt$Cattle_Open - mean(Cattle_dt$Cattle_Open)) / sd(Cattle_dt$Cattle_Open)

cocoa_full_scaled  <- (Cocoa_dt$Cocoa_Open - mean(Cocoa_dt$Cocoa_Open)) / sd(Cocoa_dt$Cocoa_Open)

coffee_full_scaled <- (Coffee_dt$Coffee_Open - mean(Coffee_dt$Coffee_Open)) / sd(Coffee_dt$Coffee_Open)

crude_full_scaled  <- (Crude_dt$Crude_Open - mean(Crude_dt$Crude_Open)) / sd(Crude_dt$Crude_Open)

gold_full_scaled   <- (Gold_dt$Gold_Open - mean(Gold_dt$Gold_Open)) / sd(Gold_dt$Gold_Open)

nyse_full_scaled   <- (NYSE_dt$NYSE_Open - mean(NYSE_dt$NYSE_Open)) / sd(NYSE_dt$NYSE_Open)

silver_full_scaled <- (Silver_dt$Silver_Open - mean(Silver_dt$Silver_Open)) / sd(Silver_dt$Silver_Open)

sp500_full_scaled  <- (sp500_dt$sp500_Open - mean(sp500_dt$sp500_Open)) / sd(sp500_dt$sp500_Open)

sugar_full_scaled  <- (Sugar_dt$Sugar_Open - mean(Sugar_dt$Sugar_Open)) / sd(Sugar_dt$Sugar_Open)

wheat_full_scaled  <- (Wheat_dt$Wheat_Open - mean(Wheat_dt$Wheat_Open)) / sd(Wheat_dt$Wheat_Open)


all_variables_scaled_df <- as.data.frame(cbind(Gold_dt$Gold_Date, amazon_full_scaled, boeing_full_scaled, cattle_full_scaled, cocoa_full_scaled,
                       coffee_full_scaled, crude_full_scaled, gold_full_scaled, nyse_full_scaled, silver_full_scaled,
                       sp500_full_scaled, sugar_full_scaled, wheat_full_scaled))

all_variables_scaled_df[,1] <- lubridate::ymd(Gold_dt$Gold_Date)

colnames(all_variables_scaled_df) <- c("Date", "Amazon", "Boeing", "Cattle", "Cocoa", "Coffee", "Crude", "Gold", "NYSE", "Silver", "SP_500", "Sugar", "Wheat")

all_variable_chart <- ggplot(all_variables_scaled_df, aes(x = Date)) +
  scale_x_date(date_labels = "%Y-%m-%d") +
  theme(axis.text.x = element_text(angle = 30, hjust = 1)) +
  geom_line(aes(y = Amazon, color = "Amazon")) +
  geom_line(aes(y = Boeing, color = "Boeing")) +
  # geom_line(aes(y = Cattle, color = "Cattle")) +
  geom_line(aes(y = Cocoa, color = "Cocoa")) +
  # geom_line(aes(y = Coffee, color = "Coffee")) +
  geom_line(aes(y = Crude, color = "Crude")) +
  geom_line(aes(y = Gold, color = "Gold")) +
  labs(y = "Scaled Values", colour = "Items")
  # geom_line(aes(y = Gold, color = "Gold")) +
  # geom_line(aes(y = NYSE, color = "NYSE")) +
  # geom_line(aes(y = Silver, color = "Silver")) +
  # geom_line(aes(y = SP_500, color = "S&P 500")) +
  # geom_line(aes(y = Sugar, color = "Sugar")) +
  # geom_line(aes(y = Wheat, color = "Wheat"))

ggplotly(all_variable_chart)

