

# Project code written by Stefan Skinner @ stefansdatascience@gmail.com 



##### ##### AMZN Setup ##### ##### #####

Amazon_dt <- fread("../finance_data/AMZN_daily_.csv")

Amazon_dt$`Date` <- lubridate::ymd(Amazon_dt$`Date`)

Amazon_dt <- Amazon_dt[,1:2] # :5]

# class(Amazon_dt$Open)

Amazon_dt[,2] <- round(as.double(unlist(Amazon_dt[,2])), 2)
# Amazon_dt[,3] <- round(as.double(unlist(Amazon_dt[,3])), 2)
# Amazon_dt[,4] <- round(as.double(unlist(Amazon_dt[,4])), 2)
# Amazon_dt[,5] <- round(as.double(unlist(Amazon_dt[,5])), 2)

na_list <- which(is.na(Amazon_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Amazon_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Amazon_dt[na_list[i],2] <- round(mean((sum(Amazon_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Amazon_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Amazon_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Amazon_dt[na_list[i],3] <- round(mean((sum(Amazon_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Amazon_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Amazon_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Amazon_dt[na_list[i],4] <- round(mean((sum(Amazon_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Amazon_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Amazon_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Amazon_dt[na_list[i],5] <- round(mean((sum(Amazon_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Amazon_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Amazon_dt[,1:ncol(Amazon_dt)]) == TRUE)

colnames(Amazon_dt) <- c("Amazon_Date", "Amazon_Open") # , "Amazon_High", "Amazon_Low", "Amazon_Close")

# View(head(Amazon_dt))

##### ##### End Amazon Setup ##### ##### #####

# *****

##### ##### Boeing Setup ##### ##### #####

Boeing_dt <- fread("../finance_data/Boeing_BA.csv")

Boeing_dt$`Date` <- lubridate::ymd(Boeing_dt$`Date`)

Boeing_dt <- Boeing_dt[,1:2] # :5]

# class(Boeing_dt$Open)

Boeing_dt[,2] <- round(as.double(unlist(Boeing_dt[,2])), 2)
# Boeing_dt[,3] <- round(as.double(unlist(Boeing_dt[,3])), 2)
# Boeing_dt[,4] <- round(as.double(unlist(Boeing_dt[,4])), 2)
# Boeing_dt[,5] <- round(as.double(unlist(Boeing_dt[,5])), 2)

na_list <- which(is.na(Boeing_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Boeing_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Boeing_dt[na_list[i],2] <- round(mean((sum(Boeing_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Boeing_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Boeing_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Boeing_dt[na_list[i],3] <- round(mean((sum(Boeing_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Boeing_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Boeing_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Boeing_dt[na_list[i],4] <- round(mean((sum(Boeing_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Boeing_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Boeing_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Boeing_dt[na_list[i],5] <- round(mean((sum(Boeing_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Boeing_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Boeing_dt[,1:ncol(Boeing_dt)]) == TRUE)

colnames(Boeing_dt) <- c("Boeing_Date", "Boeing_Open") # , "Boeing_High", "Boeing_Low", "Boeing_Close")

# View(head(Boeing_dt))

##### ##### End Boeing Setup ##### ##### #####

# *****

##### ##### Chicago Wheat Futures Setup ##### ##### #####

Wheat_dt <- fread("../finance_data/Chicago_Wheat_Futures_ZW=F.csv")

Wheat_dt$`Date` <- lubridate::ymd(Wheat_dt$`Date`)

Wheat_dt <- Wheat_dt[,1:2] # :5]

# class(Wheat_dt$Open)

Wheat_dt[,2] <- round(as.double(unlist(Wheat_dt[,2])), 2)
# Wheat_dt[,3] <- round(as.double(unlist(Wheat_dt[,3])), 2)
# Wheat_dt[,4] <- round(as.double(unlist(Wheat_dt[,4])), 2)
# Wheat_dt[,5] <- round(as.double(unlist(Wheat_dt[,5])), 2)

na_list <- which(is.na(Wheat_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Wheat_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Wheat_dt[na_list[i],2] <- round(mean((sum(Wheat_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Wheat_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Wheat_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Wheat_dt[na_list[i],3] <- round(mean((sum(Wheat_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Wheat_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Wheat_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Wheat_dt[na_list[i],4] <- round(mean((sum(Wheat_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Wheat_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Wheat_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Wheat_dt[na_list[i],5] <- round(mean((sum(Wheat_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Wheat_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Wheat_dt[,1:ncol(Wheat_dt)]) == TRUE)

colnames(Wheat_dt) <- c("Wheat_Date", "Wheat_Open") # , "Wheat_High", "Wheat_Low", "Wheat_Close")

# View(head(Wheat_dt))

##### ##### End Chicago Wheat Futures Setup ##### ##### #####

# *****

##### ##### Cocoa Futures Setup ##### ##### #####

Cocoa_dt <- fread("../finance_data/cocoa_futures_daily_CC=F.csv")

Cocoa_dt$`Date` <- lubridate::ymd(Cocoa_dt$`Date`)

Cocoa_dt <- Cocoa_dt[,1:2] # :5]

# class(Cocoa_dt$Open)

Cocoa_dt[,2] <- round(as.double(unlist(Cocoa_dt[,2])), 2)
# Cocoa_dt[,3] <- round(as.double(unlist(Cocoa_dt[,3])), 2)
# Cocoa_dt[,4] <- round(as.double(unlist(Cocoa_dt[,4])), 2)
# Cocoa_dt[,5] <- round(as.double(unlist(Cocoa_dt[,5])), 2)

na_list <- which(is.na(Cocoa_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Cocoa_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Cocoa_dt[na_list[i],2] <- round(mean((sum(Cocoa_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Cocoa_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Cocoa_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Cocoa_dt[na_list[i],3] <- round(mean((sum(Cocoa_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Cocoa_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Cocoa_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Cocoa_dt[na_list[i],4] <- round(mean((sum(Cocoa_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Cocoa_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Cocoa_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Cocoa_dt[na_list[i],5] <- round(mean((sum(Cocoa_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Cocoa_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Cocoa_dt[,1:ncol(Cocoa_dt)]) == TRUE)

colnames(Cocoa_dt) <- c("Cocoa_Date", "Cocoa_Open") # , "Cocoa_High", "Cocoa_Low", "Cocoa_Close")

# View(head(Cocoa_dt))

##### ##### End Cocoa Setup ##### ##### #####

# *****

##### ##### Start Coffee Setup ##### ##### #####

Coffee_dt <- fread("../finance_data/Coffee_KC=F.csv")

Coffee_dt$`Date` <- lubridate::ymd(Coffee_dt$`Date`)

Coffee_dt <- Coffee_dt[,1:2] # :5]

# class(Coffee_dt$Open)

Coffee_dt[,2] <- round(as.double(unlist(Coffee_dt[,2])), 2)
# Coffee_dt[,3] <- round(as.double(unlist(Coffee_dt[,3])), 2)
# Coffee_dt[,4] <- round(as.double(unlist(Coffee_dt[,4])), 2)
# Coffee_dt[,5] <- round(as.double(unlist(Coffee_dt[,5])), 2)

na_list <- which(is.na(Coffee_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Coffee_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Coffee_dt[na_list[i],2] <- round(mean((sum(Coffee_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Coffee_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Coffee_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Coffee_dt[na_list[i],3] <- round(mean((sum(Coffee_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Coffee_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Coffee_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Coffee_dt[na_list[i],4] <- round(mean((sum(Coffee_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Coffee_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Coffee_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Coffee_dt[na_list[i],5] <- round(mean((sum(Coffee_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Coffee_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Coffee_dt[,1:ncol(Coffee_dt)]) == TRUE)

colnames(Coffee_dt) <- c("Coffee_Date", "Coffee_Open") # , "Coffee_High", "Coffee_Low", "Coffee_Close")

# View(head(Coffee_dt))

##### ##### End Coffee Setup ##### ##### #####

# *****

##### ##### Crude Setup ##### ##### #####

Crude_dt <- fread("../finance_data/Crude_CL=F.csv")

Crude_dt$`Date` <- lubridate::ymd(Crude_dt$`Date`)

Crude_dt <- Crude_dt[,1:2] # :5]

# class(Crude_dt$Open)

Crude_dt[,2] <- round(as.double(unlist(Crude_dt[,2])), 2)
# Crude_dt[,3] <- round(as.double(unlist(Crude_dt[,3])), 2)
# Crude_dt[,4] <- round(as.double(unlist(Crude_dt[,4])), 2)
# Crude_dt[,5] <- round(as.double(unlist(Crude_dt[,5])), 2)

na_list <- which(is.na(Crude_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Crude_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Crude_dt[na_list[i],2] <- round(mean((sum(Crude_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Crude_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Crude_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Crude_dt[na_list[i],3] <- round(mean((sum(Crude_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Crude_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Crude_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Crude_dt[na_list[i],4] <- round(mean((sum(Crude_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Crude_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Crude_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Crude_dt[na_list[i],5] <- round(mean((sum(Crude_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Crude_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Crude_dt[,1:ncol(Crude_dt)]) == TRUE)

colnames(Crude_dt) <- c("Crude_Date", "Crude_Open") # , "Crude_High", "Crude_Low", "Crude_Close")

# View(head(Crude_dt))

##### ##### End Crude Setup ##### ##### #####

# *****

##### ##### Live Cattle Futures Setup ##### ##### #####

Cattle_dt <- fread("../finance_data/Live_Cattle_Futures_(LE=F)_.csv")

Cattle_dt <- Cattle_dt[,1:2] # :5]

colnames(Cattle_dt) <- c("Cattle_Date", "Cattle_Open") # , "Cattle_High", "Cattle_Low", "Cattle_Close")

Cattle_dt$Cattle_Date <- lubridate::mdy(Cattle_dt$Cattle_Date)

Cattle_dt <- purrr::map_df(Cattle_dt, rev)

# class(Cattle_dt$Cattle_Date)

Cattle_dt[,2] <- round(as.double(unlist(Cattle_dt[,2])), 2)
# Cattle_dt[,3] <- round(as.double(unlist(Cattle_dt[,3])), 2)
# Cattle_dt[,4] <- round(as.double(unlist(Cattle_dt[,4])), 2)
# Cattle_dt[,5] <- round(as.double(unlist(Cattle_dt[,5])), 2)

na_list <- which(is.na(Cattle_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Cattle_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Cattle_dt[na_list[i],2] <- round(mean((sum(Cattle_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Cattle_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Cattle_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Cattle_dt[na_list[i],3] <- round(mean((sum(Cattle_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Cattle_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Cattle_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Cattle_dt[na_list[i],4] <- round(mean((sum(Cattle_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Cattle_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Cattle_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Cattle_dt[na_list[i],5] <- round(mean((sum(Cattle_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Cattle_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Cattle_dt[,1:ncol(Cattle_dt)]) == TRUE)

# View(head(Cattle_dt))

##### ##### End Live Cattle Futures Setup ##### ##### #####

# *****

##### ##### Gold Setup ##### ##### #####

Gold_dt <- fread("../finance_data/Gold_GC=F.csv")

Gold_dt$`Date` <- lubridate::ymd(Gold_dt$`Date`)

Gold_dt <- Gold_dt[,1:2] # :5]

# class(Gold_dt$Open)

Gold_dt[,2] <- round(as.double(unlist(Gold_dt[,2])), 2)
# Gold_dt[,3] <- round(as.double(unlist(Gold_dt[,3])), 2)
# Gold_dt[,4] <- round(as.double(unlist(Gold_dt[,4])), 2)
# Gold_dt[,5] <- round(as.double(unlist(Gold_dt[,5])), 2)

na_list <- which(is.na(Gold_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Gold_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Gold_dt[na_list[i],2] <- round(mean((sum(Gold_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Gold_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Gold_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Gold_dt[na_list[i],3] <- round(mean((sum(Gold_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Gold_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Gold_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Gold_dt[na_list[i],4] <- round(mean((sum(Gold_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Gold_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Gold_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Gold_dt[na_list[i],5] <- round(mean((sum(Gold_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Gold_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Gold_dt[,1:ncol(Gold_dt)]) == TRUE)

colnames(Gold_dt) <- c("Gold_Date", "Gold_Open") # , "Gold_High", "Gold_Low", "Gold_Close")

# View(head(Gold_dt))

##### ##### End Gold Setup ##### ##### #####

# *****

##### ##### NYSE Setup ##### ##### #####

NYSE_dt <- fread("../finance_data/NYSE_^NYA.csv")

NYSE_dt$`Date` <- lubridate::ymd(NYSE_dt$`Date`)

NYSE_dt <- NYSE_dt[,1:2] # :5]

# class(NYSE_dt$Open)

NYSE_dt[,2] <- round(as.double(unlist(NYSE_dt[,2])), 2)
# NYSE_dt[,3] <- round(as.double(unlist(NYSE_dt[,3])), 2)
# NYSE_dt[,4] <- round(as.double(unlist(NYSE_dt[,4])), 2)
# NYSE_dt[,5] <- round(as.double(unlist(NYSE_dt[,5])), 2)

na_list <- which(is.na(NYSE_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(NYSE_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    NYSE_dt[na_list[i],2] <- round(mean((sum(NYSE_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(NYSE_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(NYSE_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   NYSE_dt[na_list[i],3] <- round(mean((sum(NYSE_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(NYSE_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(NYSE_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   NYSE_dt[na_list[i],4] <- round(mean((sum(NYSE_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(NYSE_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(NYSE_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   NYSE_dt[na_list[i],5] <- round(mean((sum(NYSE_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(NYSE_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(NYSE_dt[,1:ncol(NYSE_dt)]) == TRUE)

colnames(NYSE_dt) <- c("NYSE_Date", "NYSE_Open") # , "NYSE_High", "NYSE_Low", "NYSE_Close")

# View(head(NYSE_dt))

##### ##### End NYSE Setup ##### ##### #####

# *****

##### ##### Silver Spot Setup ##### ##### #####

# rm(Silver_dt)

Silver_dt <- fread("../finance_data/Silver_spot_data__XAG_USA_.csv")
Silver_dt[1,1]

Silver_dt <- Silver_dt[,c(1, 2)] # :5]

colnames(Silver_dt) <- c("Silver_Date", "Silver_Open") # , "Silver_High", "Silver_Low", "Silver_Close")

Silver_dt$Silver_Date <- lubridate::mdy(Silver_dt$Silver_Date)

# class(Silver_dt$Silver_Data)

Silver_dt[,2] <- round(as.double(unlist(Silver_dt[,2])), 2)
# Silver_dt[,3] <- round(as.double(unlist(Silver_dt[,3])), 2)
# Silver_dt[,4] <- round(as.double(unlist(Silver_dt[,4])), 2)
# Silver_dt[,5] <- round(as.double(unlist(Silver_dt[,5])), 2)

na_list <- which(is.na(Silver_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Silver_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Silver_dt[na_list[i],2] <- round(mean((sum(Silver_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Silver_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Silver_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Silver_dt[na_list[i],3] <- round(mean((sum(Silver_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Silver_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Silver_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Silver_dt[na_list[i],4] <- round(mean((sum(Silver_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Silver_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Silver_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Silver_dt[na_list[i],5] <- round(mean((sum(Silver_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Silver_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Silver_dt[,1:ncol(Silver_dt)]) == TRUE)

Silver_dt <- purrr::map_df(Silver_dt, rev)

# View(head(Silver_dt))

##### ##### End Silver Spot Setup ##### ##### #####

# *****

##### ##### S&P 500 Setup ##### ##### #####

sp500_dt <- fread("../finance_data/sp500_^GSPC.csv")

sp500_dt$`Date` <- lubridate::ymd(sp500_dt$`Date`)

sp500_dt <- sp500_dt[,1:2] # :5]

# class(sp500_dt$Open)

sp500_dt[,2] <- round(as.double(unlist(sp500_dt[,2])), 2)
# sp500_dt[,3] <- round(as.double(unlist(sp500_dt[,3])), 2)
# sp500_dt[,4] <- round(as.double(unlist(sp500_dt[,4])), 2)
# sp500_dt[,5] <- round(as.double(unlist(sp500_dt[,5])), 2)

na_list <- which(is.na(sp500_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(sp500_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    sp500_dt[na_list[i],2] <- round(mean((sum(sp500_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(sp500_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(sp500_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   sp500_dt[na_list[i],3] <- round(mean((sum(sp500_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(sp500_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(sp500_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   sp500_dt[na_list[i],4] <- round(mean((sum(sp500_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(sp500_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(sp500_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   sp500_dt[na_list[i],5] <- round(mean((sum(sp500_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(sp500_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(sp500_dt[,1:ncol(sp500_dt)]) == TRUE)

colnames(sp500_dt) <- c("sp500_Date", "sp500_Open") # , "sp500_High", "sp500_Low", "sp500_Close")

# View(head(sp500_dt))

##### ##### End S&P 500 Setup ##### ##### #####

# *****

##### ##### Sugar Setup ##### ##### #####

Sugar_dt <- fread("../finance_data/Sugar_SB=F.csv")

Sugar_dt$`Date` <- lubridate::ymd(Sugar_dt$`Date`)

Sugar_dt <- Sugar_dt[,1:2] # :5]

# class(Sugar_dt$Open)

Sugar_dt[,2] <- round(as.double(unlist(Sugar_dt[,2])), 2)
# Sugar_dt[,3] <- round(as.double(unlist(Sugar_dt[,3])), 2)
# Sugar_dt[,4] <- round(as.double(unlist(Sugar_dt[,4])), 2)
# Sugar_dt[,5] <- round(as.double(unlist(Sugar_dt[,5])), 2)

na_list <- which(is.na(Sugar_dt))

if(any(!is.na(na_list)) == TRUE)
{
  
  na_list <- as.vector(which(is.na(Sugar_dt[,2]) == TRUE))
  
  for(i in 1:length(na_list))
  {
    Sugar_dt[na_list[i],2] <- round(mean((sum(Sugar_dt[(na_list[i]-5):(na_list[i]-1), 2])/5), (sum(Sugar_dt[(na_list[i]+1):(na_list[i]+5), 2]/5))), 2)
    
  } # end for
  
  # na_list <- as.vector(which(is.na(Sugar_dt[,3]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Sugar_dt[na_list[i],3] <- round(mean((sum(Sugar_dt[(na_list[i]-5):(na_list[i]-1), 3])/5), (sum(Sugar_dt[(na_list[i]+1):(na_list[i]+5), 3]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Sugar_dt[,4]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Sugar_dt[na_list[i],4] <- round(mean((sum(Sugar_dt[(na_list[i]-5):(na_list[i]-1), 4])/5), (sum(Sugar_dt[(na_list[i]+1):(na_list[i]+5), 4]/5))), 2)
  #   
  # } # end for
  # 
  # na_list <- as.vector(which(is.na(Sugar_dt[,5]) == TRUE))
  # 
  # for(i in 1:length(na_list))
  # {
  #   Sugar_dt[na_list[i],5] <- round(mean((sum(Sugar_dt[(na_list[i]-5):(na_list[i]-1), 5])/5), (sum(Sugar_dt[(na_list[i]+1):(na_list[i]+5), 5]/5))), 2)
  #   
  # } # end for
  
} # end outer if    

# which(is.na(Sugar_dt[,1:ncol(Sugar_dt)]) == TRUE)

colnames(Sugar_dt) <- c("Sugar_Date", "Sugar_Open") #, "Sugar_High", "Sugar_Low", "Sugar_Close")

# View(head(Sugar_dt))

##### ##### End Sugar Setup ##### ##### #####


# *****

# nrow(Amazon_dt)
# nrow(Boeing_dt)
# nrow(Cattle_dt)
# nrow(Cocoa_dt)
# nrow(Coffee_dt)
# nrow(Crude_dt)
# nrow(Gold_dt)
# nrow(NYSE_dt)
# nrow(Silver_dt)
# nrow(sp500_dt)
# nrow(Sugar_dt)
# nrow(Wheat_dt)
# 
# Amazon_dt$Amazon_Date[1]
# Boeing_dt$Boeing_Date[1]
# Cattle_dt$Cattle_Date[1]
# Cocoa_dt$Cocoa_Date[1]
# Coffee_dt$Coffee_Date[1]
# Crude_dt$Crude_Date[1]
# Gold_dt$Gold_Date[1]
# NYSE_dt$NYSE_Date[1]
# Silver_dt$Silver_Date[1]
# sp500_dt$sp500_Date[1]
# Sugar_dt$Sugar_Date[1]
# Wheat_dt$Wheat_Date[1]
# 
# 
# Amazon_dt[nrow(Amazon_dt),1]
# 
# nrow(Amazon_dt)

##### Silver modifications #####

Silver_dt <- purrr::map_df(Silver_dt, rev)

nrow(Silver_dt)

Silver_dt <- Silver_dt %>% filter(Silver_Date %in% Amazon_dt$Amazon_Date)

nrow(Silver_dt)

# View(head(Silver_dt))

##### end Silver modifications #####

# Amazon_dt$Amazon_Date[length(Amazon_dt$Amazon_Date)]
# Boeing_dt$Boeing_Date[length(Boeing_dt$Boeing_Date)]
# Cattle_dt$Cattle_Date[length(Cattle_dt$Cattle_Date)]
# Cocoa_dt$Cocoa_Date[length(Cocoa_dt$Cocoa_Date)]
# Coffee_dt$Coffee_Date[length(Coffee_dt$Coffee_Date)]
# Crude_dt$Crude_Date[length(Crude_dt$Crude_Date)]
# Gold_dt$Gold_Date[length(Gold_dt$Gold_Date)]
# NYSE_dt$NYSE_Date[length(NYSE_dt$NYSE_Date)]
# Silver_dt$Silver_Date[length(Silver_dt$Silver_Date)]
# sp500_dt$sp500_Date[length(sp500_dt$sp500_Date)]
# Sugar_dt$Sugar_Date[length(Sugar_dt$Sugar_Date)]
# Wheat_dt$Wheat_Date[length(Wheat_dt$Wheat_Date)]

##### Cattle modifications #####

# nrow(Cattle_dt)

Cattle_dt <- Cattle_dt %>% filter(Cattle_Date %in% Amazon_dt$Amazon_Date)

# nrow(Cattle_dt)

# View(head(Cattle_dt))

##### end Cattle modifications #####

##### Amazon modifications #####

# nrow(Amazon_dt)

Amazon_dt <- Amazon_dt %>% filter(Amazon_Date %in% Cattle_dt$Cattle_Date)

# nrow(Amazon_dt)

# View(head(Amazon_dt))

##### end Amazon modifications #####

##### Boeing modifications #####

# nrow(Boeing_dt)

Boeing_dt <- Boeing_dt %>% filter(Boeing_Date %in% Cattle_dt$Cattle_Date)

# nrow(Boeing_dt)

# View(head(Boeing_dt))

##### end Boeing modifications #####

##### Cocoa modifications #####

# nrow(Cocoa_dt)

Cocoa_dt <- Cocoa_dt %>% filter(Cocoa_Date %in% Amazon_dt$Amazon_Date)

# nrow(Cocoa_dt)

# View(head(Cocoa_dt))

##### end Cocoa modifications #####

##### Coffee modifications #####

# nrow(Coffee_dt)

Coffee_dt <- Coffee_dt %>% filter(Coffee_Date %in% Amazon_dt$Amazon_Date)

# nrow(Coffee_dt)

# View(head(Coffee_dt))

##### end Coffee modifications #####

##### Crude modifications #####

# nrow(Crude_dt)

Crude_dt <- Crude_dt %>% filter(Crude_Date %in% Amazon_dt$Amazon_Date)

# nrow(Crude_dt)

# View(head(Crude_dt))

##### end Crude modifications #####

##### Gold modifications #####

# nrow(Gold_dt)

Gold_dt <- Gold_dt %>% filter(Gold_Date %in% Amazon_dt$Amazon_Date)

# nrow(Gold_dt)

# View(head(Gold_dt))

##### end Gold modifications #####

##### NYSE modifications #####

# nrow(NYSE_dt)

NYSE_dt <- NYSE_dt %>% filter(NYSE_Date %in% Amazon_dt$Amazon_Date)

# nrow(NYSE_dt)

# View(head(NYSE_dt))

##### end NYSE modifications #####

##### Silver modifications #####

# nrow(Silver_dt)

Silver_dt <- Silver_dt %>% filter(Silver_Date %in% Amazon_dt$Amazon_Date)

# nrow(Silver_dt)

# View(head(Silver_dt))

##### end Silver modifications #####


##### sp500 modifications #####

# nrow(sp500_dt)

sp500_dt <- sp500_dt %>% filter(sp500_Date %in% Amazon_dt$Amazon_Date)

# nrow(sp500_dt)

# View(head(sp500_dt))

##### end sp500 modifications #####

##### Sugar modifications #####

# nrow(Sugar_dt)

Sugar_dt <- Sugar_dt %>% filter(Sugar_Date %in% Amazon_dt$Amazon_Date)

# nrow(Sugar_dt)

# View(head(Sugar_dt))

##### end Sugar modifications #####

##### Wheat modifications #####

# nrow(Wheat_dt)

Wheat_dt <- Wheat_dt %>% filter(Wheat_Date %in% Amazon_dt$Amazon_Date)

# nrow(Wheat_dt)

# View(head(Wheat_dt))

##### end Wheat modifications #####

# nrow(Amazon_dt)
# nrow(Boeing_dt)
# nrow(Cattle_dt)
# nrow(Cocoa_dt)
# nrow(Coffee_dt)
# nrow(Crude_dt)
# nrow(Gold_dt)
# nrow(NYSE_dt)
# nrow(Silver_dt)
# nrow(sp500_dt)
# nrow(Sugar_dt)
# nrow(Wheat_dt)


##### EOF #####

paste("End of File")

##### EOF #####


